package easik.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;

import easik.sketch.document.DocInfoUI;


/** 
 * Menu action for quitting the application.
 * 
 * @author Kevin Green 2006
 * @since 20006-06-22 Kevin Green
 * @version 2006-06-22 Kevin Green
 */

public class DocumentInfoAction extends AbstractAction {	
	/**
	 *	Set up the document menu option.
	 */
	public DocumentInfoAction() {
		super("Document Information");
		putValue( AbstractAction.MNEMONIC_KEY,  new Integer(KeyEvent.VK_I));
		putValue( AbstractAction.SHORT_DESCRIPTION,  "Information about the current sketch");		
	}
	
	/**
	 * Brings up a dialog to set the document header information.
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		//System.out.println("Set document header info pressed!");
		new DocInfoUI();
	}
}